/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.common.util.Translator;
import mezz.jei.gui.ingredients.DisplayNameUtil;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.ListElement;
import mezz.jei.gui.ingredients.ListElementInfoTooltip;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ListElementInfo<V>
implements IListElementInfo<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int elementCount = 0;
    private final IListElement<V> element;
    private final List<String> names;
    private final List<String> modIds;
    private final List<String> modNames;
    private final class_2960 resourceLocation;

    @Nullable
    public static <V> IListElementInfo<V> create(ITypedIngredient<V> value, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        int createdIndex = elementCount++;
        ListElement<V> element = new ListElement<V>(value, createdIndex);
        return ListElementInfo.createFromElement(element, ingredientManager, modIdHelper);
    }

    @Nullable
    public static <V> IListElementInfo<V> createFromElement(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        try {
            return new ListElementInfo<V>(element, ingredientManager, modIdHelper);
        }
        catch (RuntimeException e) {
            try {
                ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
                IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(typedIngredient.getType());
                String ingredientInfo = ingredientHelper.getErrorInfo(typedIngredient.getIngredient());
                LOGGER.warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                LOGGER.warn("Found a broken ingredient.", (Throwable)e2);
            }
            return null;
        }
    }

    protected ListElementInfo(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        this.element = element;
        ITypedIngredient<V> value = element.getTypedIngredient();
        V ingredient = value.getIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        this.resourceLocation = ingredientHelper.getResourceLocation(ingredient);
        String displayModId = ingredientHelper.getDisplayModId(ingredient);
        String modId = this.resourceLocation.method_12836();
        if (modId.equals(displayModId)) {
            this.modIds = List.of(modId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId));
        } else {
            this.modIds = List.of(modId, displayModId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId), modIdHelper.getModNameForModId(displayModId));
        }
        String displayNameLowercase = DisplayNameUtil.getLowercaseDisplayNameForSearch(ingredient, ingredientHelper);
        Collection<String> aliases = ingredientManager.getIngredientAliases(value);
        if (aliases.isEmpty()) {
            this.names = List.of(displayNameLowercase);
        } else {
            this.names = new ArrayList<String>(1 + aliases.size());
            this.names.add(displayNameLowercase);
            for (String alias : aliases) {
                String lowercaseAlias = Translator.toLowercaseWithLocale(alias);
                this.names.add(lowercaseAlias);
            }
        }
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getModNameForSorting() {
        return this.modNames.getFirst();
    }

    @Override
    public List<String> getModNames() {
        return this.modNames;
    }

    @Override
    public List<String> getModIds() {
        return this.modIds;
    }

    @Override
    public final @Unmodifiable Set<String> getTooltipStrings(IIngredientFilterConfig config, IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientRenderer<V> ingredientRenderer = ingredientManager.getIngredientRenderer(value.getType());
        class_1836.class_1837 tooltipFlag = config.getSearchAdvancedTooltips() ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        tooltipFlag = tooltipFlag.method_47371();
        ListElementInfoTooltip tooltip = new ListElementInfoTooltip();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, value, (class_1836)tooltipFlag);
        Set<String> strings = tooltip.getStrings();
        strings.remove(this.names.getFirst());
        strings.remove(this.modNames.getFirst().toLowerCase(Locale.ENGLISH));
        strings.remove(this.modIds.getFirst());
        strings.remove(this.resourceLocation.method_12832());
        return strings;
    }

    @Override
    public Collection<String> getTagStrings(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient()).map(class_2960::method_12832).toList();
    }

    @Override
    public Stream<class_2960> getTagIds(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient());
    }

    @Override
    public Iterable<Integer> getColors(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        V ingredient = value.getIngredient();
        return ingredientHelper.getColors(ingredient);
    }

    @Override
    public @Unmodifiable Collection<String> getCreativeTabsStrings(IIngredientManager ingredientManager) {
        class_1799 itemStack = this.element.getTypedIngredient().getItemStack().orElse(class_1799.field_8037);
        if (itemStack.method_7960()) {
            return List.of();
        }
        HashSet<String> creativeTabStrings = new HashSet<String>();
        for (class_1761 itemGroup : class_7706.method_47341()) {
            if (!itemGroup.method_47311() || itemGroup.method_47312() != class_1761.class_7916.field_41052 || !itemGroup.method_45412(itemStack)) continue;
            String name = itemGroup.method_7737().getString();
            name = StringUtil.removeChatFormatting(name);
            name = Translator.toLowercaseWithLocale(name);
            Collections.addAll(creativeTabStrings, name.split(" "));
        }
        return creativeTabStrings;
    }

    @Override
    public class_2960 getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public IListElement<V> getElement() {
        return this.element;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public int getCreatedIndex() {
        return this.element.getCreatedIndex();
    }
}

